from zipfile import ZipFile, ZipInfo
from io import BytesIO
from .filename_preparation import shorten_file_name_by_bytes_size
from ..entities.file_metadata import FileMetadata


def create_zip_file(files: tuple[FileMetadata, bytes], max_file_name_system_limit_in_bytes: int) -> bytes:
    buffer = BytesIO()

    with ZipFile(buffer, 'w') as zip_archive:
        for metadata, payload in files:
            # If file name contains '/' zipfile lib thinking that it's subdirectories,
            # splitting name by it and creating archive with subdirectories
            # e.g. 'foo/bar.pdf' - in archive will be created folder foo and inside it file bar.pdf
            if '/' in metadata.full_file_name:
                metadata.full_file_name = metadata.full_file_name.replace('/', '-')

            file_name = shorten_file_name_by_bytes_size(
                metadata.full_file_name, max_file_name_system_limit_in_bytes
            )

            file = ZipInfo(file_name)
            zip_archive.writestr(file, payload)

    return buffer.getvalue()
