#  Copyright (C) 2024
#  ABM, Moscow
#
#  UNPUBLISHED PROPRIETARY MATERIAL.
#  ALL RIGHTS RESERVED.
#
#  Authors: Mike Orlov <m.orlov@abm-jsc.ru>
import traceback
import typing
from typing import Any

from sqlalchemy.ext.asyncio import AsyncSession

from .database import WrappedSession

AnySession: typing.TypeAlias = AsyncSession | WrappedSession | None
T = typing.TypeVar('T', bound=Any)

@typing.overload
def assert_raise(condition: Any, exception: Exception) -> None: pass


@typing.overload
def assert_raise(condition: Any, exception: type[Exception], *args) -> None: pass


def assert_raise(condition: Any, exception: Exception | type[Exception], *args) -> None:
    if not condition:
        if isinstance(exception, type) and args:
            exception = exception(*args)
        raise exception


async def silent(awaitable: typing.Awaitable[T], default: Any = None) -> T | Any:
    try:
        return await awaitable
    except Exception:
        traceback.print_exc()
        return default
