#  Copyright (C) 2024
#  ABM, Moscow
#
#  UNPUBLISHED PROPRIETARY MATERIAL.
#  ALL RIGHTS RESERVED.
#
#  Authors: Mike Orlov <m.orlov@abm-jsc.ru>
from sqlalchemy import String
from sqlalchemy_tools.entity_helpers.decorator import sqlalchemy_dataclass
from sqlalchemy_tools.entity_helpers.fields import sql_field, make_field__created_at, sql_relation_field
from sqlalchemy_tools.entity_helpers.fk_keys import CascadeForeignKey
from sqlalchemy_tools.entity_helpers.sqlalchemy_base import sqlalchemy_mapper_registry

from .file_info import FileInfo


@sqlalchemy_dataclass(sqlalchemy_mapper_registry)
class LinkInfo:
    id: str = sql_field(String, primary_key=True, allow_init_primary_key=True)  # used in API
    file_info_key: str = sql_field(String, CascadeForeignKey(FileInfo.key), index=True, nullable=False)
    filename: str = sql_field(String, nullable=False)
    extension: str = sql_field(String, nullable=True)
    created_at: float = make_field__created_at()
    file_info: FileInfo = sql_relation_field(FileInfo, use_list=False, lazy='joined')
