#  Copyright (C) 2024
#  ABM, Moscow
#
#  UNPUBLISHED PROPRIETARY MATERIAL.
#  ALL RIGHTS RESERVED.
#
#  Authors:
#  Andrey Vaydich <a.vaydich@abm-jsc.ru>

from pathlib import Path


def convert_file_name(file_name: str, max_required_bytes_size: int) -> str:
    return trim_file_name_by_bytes_len(file_name_replace_slash(file_name), max_required_bytes_size)

# If file name contains '/' zipfile lib thinking that it's subdirectories,
# splitting name by it and creating archive with subdirectories
# e.g. 'foo/bar.pdf' - in archive will be created folder foo and inside it file bar.
def file_name_replace_slash(file_name: str) -> str:
    return file_name.replace('/', '-')

# Each OS has maximum file name length
# so we must shorten it to avoid error while reading (zip file in particular)
def trim_file_name_by_bytes_len(file_name: str, max_byte_len: int, encoding: str = 'utf-8') -> str:
    if len(file_name.encode(encoding)) <= max_byte_len:
        return file_name

    result: str = ''
    result_len: int = 0
    suffixes: list[str] = Path(file_name).suffixes

    while suffixes:
        suffix = suffixes.pop()

        if (new_len := result_len + len(suffix.encode(encoding))) > max_byte_len // 2:
            break

        result_len = new_len
        result = suffix + result

    i = 0

    while (new_len := result_len + len(file_name[i].encode(encoding))) <= max_byte_len:
        result_len = new_len
        i += 1

    return file_name[:i] + result
