# coding: utf-8

"""
    Mentortools

    Mentortools

    The version of the OpenAPI document: 0.1.0
    Generated by OpenAPI Generator (https://openapi-generator.tech)

    Do not edit the class manually.
"""  # noqa: E501


from __future__ import annotations
import pprint
import re  # noqa: F401
import json


from typing import List, Optional
from pydantic import BaseModel, Field, StrictStr, conlist
from google_connector.models.asc_credentials import ASCCredentials
from google_connector.models.language_code import LanguageCode
from google_connector.models.product import Product

class SetupAppData(BaseModel):
    """
    SetupAppData
    """
    credentials: ASCCredentials = Field(...)
    bundle_id: StrictStr = Field(...)
    project_id: StrictStr = Field(...)
    apps_display_name: StrictStr = Field(...)
    language: LanguageCode = Field(...)
    title: StrictStr = Field(...)
    full_description: StrictStr = Field(default=..., alias="fullDescription")
    short_description: StrictStr = Field(default=..., alias="shortDescription")
    video: Optional[StrictStr] = None
    contact_email: StrictStr = Field(default=..., alias="contactEmail")
    contact_website: Optional[StrictStr] = Field(default=None, alias="contactWebsite")
    contact_phone: Optional[StrictStr] = Field(default=None, alias="contactPhone")
    icon: StrictStr = Field(...)
    feature_graphic: StrictStr = Field(default=..., alias="featureGraphic")
    phone_screenshots: Optional[conlist(StrictStr)] = Field(default=None, alias="phoneScreenshots")
    product_list: Optional[conlist(Product)] = None
    delete_account_url: StrictStr = Field(...)
    __properties = ["credentials", "bundle_id", "project_id", "apps_display_name", "language", "title", "fullDescription", "shortDescription", "video", "contactEmail", "contactWebsite", "contactPhone", "icon", "featureGraphic", "phoneScreenshots", "product_list", "delete_account_url"]

    class Config:
        """Pydantic configuration"""
        allow_population_by_field_name = True
        validate_assignment = True

    def to_str(self) -> str:
        """Returns the string representation of the model using alias"""
        return pprint.pformat(self.dict(by_alias=True))

    def to_json(self) -> str:
        """Returns the JSON representation of the model using alias"""
        return json.dumps(self.to_dict())

    @classmethod
    def from_json(cls, json_str: str) -> SetupAppData:
        """Create an instance of SetupAppData from a JSON string"""
        return cls.from_dict(json.loads(json_str))

    def to_dict(self):
        """Returns the dictionary representation of the model using alias"""
        _dict = self.dict(by_alias=True,
                          exclude={
                          },
                          exclude_none=True)
        # override the default output from pydantic by calling `to_dict()` of credentials
        if self.credentials:
            _dict['credentials'] = self.credentials.to_dict()
        # override the default output from pydantic by calling `to_dict()` of each item in product_list (list)
        _items = []
        if self.product_list:
            for _item in self.product_list:
                if _item:
                    _items.append(_item.to_dict())
            _dict['product_list'] = _items
        # set to None if video (nullable) is None
        # and __fields_set__ contains the field
        if self.video is None and "video" in self.__fields_set__:
            _dict['video'] = None

        # set to None if contact_website (nullable) is None
        # and __fields_set__ contains the field
        if self.contact_website is None and "contact_website" in self.__fields_set__:
            _dict['contactWebsite'] = None

        # set to None if contact_phone (nullable) is None
        # and __fields_set__ contains the field
        if self.contact_phone is None and "contact_phone" in self.__fields_set__:
            _dict['contactPhone'] = None

        return _dict

    @classmethod
    def from_dict(cls, obj: dict) -> SetupAppData:
        """Create an instance of SetupAppData from a dict"""
        if obj is None:
            return None

        if not isinstance(obj, dict):
            return SetupAppData.parse_obj(obj)

        _obj = SetupAppData.parse_obj({
            "credentials": ASCCredentials.from_dict(obj.get("credentials")) if obj.get("credentials") is not None else None,
            "bundle_id": obj.get("bundle_id"),
            "project_id": obj.get("project_id"),
            "apps_display_name": obj.get("apps_display_name"),
            "language": obj.get("language"),
            "title": obj.get("title"),
            "full_description": obj.get("fullDescription"),
            "short_description": obj.get("shortDescription"),
            "video": obj.get("video"),
            "contact_email": obj.get("contactEmail"),
            "contact_website": obj.get("contactWebsite"),
            "contact_phone": obj.get("contactPhone"),
            "icon": obj.get("icon"),
            "feature_graphic": obj.get("featureGraphic"),
            "phone_screenshots": obj.get("phoneScreenshots"),
            "product_list": [Product.from_dict(_item) for _item in obj.get("product_list")] if obj.get("product_list") is not None else None,
            "delete_account_url": obj.get("delete_account_url")
        })
        return _obj


