# google-connector
Mentortools

This Python package is automatically generated by the [OpenAPI Generator](https://openapi-generator.tech) project:

- API version: 0.1.0
- Package version: 1.0.0+2109206718
- Generator version: 7.16.0
- Build package: org.openapitools.codegen.languages.PythonPydanticV1ClientCodegen

## Requirements.

Python 3.7+

## Installation & Usage
### pip install

If the python package is hosted on a repository, you can install directly using:

```sh
pip install git+https://github.com/GIT_USER_ID/GIT_REPO_ID.git
```
(you may need to run `pip` with root permission: `sudo pip install git+https://github.com/GIT_USER_ID/GIT_REPO_ID.git`)

Then import the package:
```python
import google_connector
```

### Setuptools

Install via [Setuptools](http://pypi.python.org/pypi/setuptools).

```sh
python setup.py install --user
```
(or `sudo python setup.py install` to install the package for all users)

Then import the package:
```python
import google_connector
```

### Tests

Execute `pytest` to run the tests.

## Getting Started

Please follow the [installation procedure](#installation--usage) and then run the following:

```python

import time
import google_connector
from google_connector.rest import ApiException
from pprint import pprint

# Defining the host is optional and defaults to http://localhost
# See configuration.py for a list of all supported configuration parameters.
configuration = google_connector.Configuration(
    host = "http://localhost"
)



# Enter a context with an instance of the API client
async with google_connector.ApiClient(configuration) as api_client:
    # Create an instance of the API class
    api_instance = google_connector.CorrectProjectApi(api_client)
    request_by_bundle_id = google_connector.RequestByBundleId() # RequestByBundleId | 

    try:
        # Get All Iaps
        api_response = await api_instance.setup_api_get_all_iaps(request_by_bundle_id)
        print("The response of CorrectProjectApi->setup_api_get_all_iaps:\n")
        pprint(api_response)
    except ApiException as e:
        print("Exception when calling CorrectProjectApi->setup_api_get_all_iaps: %s\n" % e)

```

## Documentation for API Endpoints

All URIs are relative to *http://localhost*

Class | Method | HTTP request | Description
------------ | ------------- | ------------- | -------------
*CorrectProjectApi* | [**setup_api_get_all_iaps**](docs/CorrectProjectApi.md#setup_api_get_all_iaps) | **PATCH** /v1/correction/get_all_iaps | Get All Iaps
*CorrectProjectApi* | [**setup_api_get_app_configs**](docs/CorrectProjectApi.md#setup_api_get_app_configs) | **PATCH** /v1/correction/get_app_configs | Get app configurations
*CorrectProjectApi* | [**setup_api_get_app_version**](docs/CorrectProjectApi.md#setup_api_get_app_version) | **PATCH** /v1/correction/get_app_version | Get App Version
*DefaultApi* | [**default_metrics**](docs/DefaultApi.md#default_metrics) | **GET** /metrics | Metrics
*SetupApiApi* | [**setup_api_create_project_by_oauth**](docs/SetupApiApi.md#setup_api_create_project_by_oauth) | **POST** /v1/project/create | Create project using OAuth2 token
*SetupApiApi* | [**setup_api_fill_app_information**](docs/SetupApiApi.md#setup_api_fill_app_information) | **PATCH** /v1/app/setup | Fill app information
*SetupApiApi* | [**setup_api_get_all_iaps**](docs/SetupApiApi.md#setup_api_get_all_iaps) | **PATCH** /v1/correction/get_all_iaps | Get All Iaps
*SetupApiApi* | [**setup_api_get_app_configs**](docs/SetupApiApi.md#setup_api_get_app_configs) | **PATCH** /v1/correction/get_app_configs | Get app configurations
*SetupApiApi* | [**setup_api_get_app_version**](docs/SetupApiApi.md#setup_api_get_app_version) | **PATCH** /v1/correction/get_app_version | Get App Version
*SetupAppApi* | [**setup_api_fill_app_information**](docs/SetupAppApi.md#setup_api_fill_app_information) | **PATCH** /v1/app/setup | Fill app information
*SetupProjectApi* | [**setup_api_create_project_by_oauth**](docs/SetupProjectApi.md#setup_api_create_project_by_oauth) | **POST** /v1/project/create | Create project using OAuth2 token


## Documentation For Models

 - [ASCCredentials](docs/ASCCredentials.md)
 - [AndroidPublisherRelease](docs/AndroidPublisherRelease.md)
 - [AndroidPublisherTrack](docs/AndroidPublisherTrack.md)
 - [AndroidVersions](docs/AndroidVersions.md)
 - [FirebaseAppConfigRequest](docs/FirebaseAppConfigRequest.md)
 - [FirebaseAppConfigResponse](docs/FirebaseAppConfigResponse.md)
 - [FirebaseAppConfigs](docs/FirebaseAppConfigs.md)
 - [HTTPValidationError](docs/HTTPValidationError.md)
 - [IAPProducts](docs/IAPProducts.md)
 - [IAPResult](docs/IAPResult.md)
 - [LanguageCode](docs/LanguageCode.md)
 - [Platform](docs/Platform.md)
 - [Product](docs/Product.md)
 - [ProjectByOauth](docs/ProjectByOauth.md)
 - [ProjectCreateResult](docs/ProjectCreateResult.md)
 - [PurchaseType](docs/PurchaseType.md)
 - [RequestByBundleId](docs/RequestByBundleId.md)
 - [ResultStatus](docs/ResultStatus.md)
 - [SetupAppData](docs/SetupAppData.md)
 - [Status](docs/Status.md)
 - [ValidationError](docs/ValidationError.md)
 - [ValidationErrorLocInner](docs/ValidationErrorLocInner.md)
 - [WrappedResponseAndroidVersions](docs/WrappedResponseAndroidVersions.md)
 - [WrappedResponseFirebaseAppConfigs](docs/WrappedResponseFirebaseAppConfigs.md)
 - [WrappedResponseIAPResult](docs/WrappedResponseIAPResult.md)
 - [WrappedResponseProjectCreateResult](docs/WrappedResponseProjectCreateResult.md)
 - [WrappedResponseResultStatus](docs/WrappedResponseResultStatus.md)


<a id="documentation-for-authorization"></a>
## Documentation For Authorization

Endpoints do not require authorization.


## Author




