# google-connector
Mentortools

This Python package is automatically generated by the [OpenAPI Generator](https://openapi-generator.tech) project:

- API version: 0.1.0
- Package version: 1.0.0+2159638657
- Generator version: 7.17.0
- Build package: org.openapitools.codegen.languages.PythonPydanticV1ClientCodegen

## Requirements.

Python 3.7+

## Installation & Usage
### pip install

If the python package is hosted on a repository, you can install directly using:

```sh
pip install git+https://github.com/GIT_USER_ID/GIT_REPO_ID.git
```
(you may need to run `pip` with root permission: `sudo pip install git+https://github.com/GIT_USER_ID/GIT_REPO_ID.git`)

Then import the package:
```python
import google_connector
```

### Setuptools

Install via [Setuptools](http://pypi.python.org/pypi/setuptools).

```sh
python setup.py install --user
```
(or `sudo python setup.py install` to install the package for all users)

Then import the package:
```python
import google_connector
```

### Tests

Execute `pytest` to run the tests.

## Getting Started

Please follow the [installation procedure](#installation--usage) and then run the following:

```python

import time
import google_connector
from google_connector.rest import ApiException
from pprint import pprint

# Defining the host is optional and defaults to http://localhost
# See configuration.py for a list of all supported configuration parameters.
configuration = google_connector.Configuration(
    host = "http://localhost"
)

# The client must configure the authentication and authorization parameters
# in accordance with the API server security policy.
# Examples for each auth method are provided below, use the example that
# satisfies your auth use case.

# Configure Bearer authorization: Bearer Authorization
configuration = google_connector.Configuration(
    access_token = os.environ["BEARER_TOKEN"]
)


# Enter a context with an instance of the API client
async with google_connector.ApiClient(configuration) as api_client:
    # Create an instance of the API class
    api_instance = google_connector.CorrectProjectApi(api_client)
    project_id_credentials = google_connector.ProjectIdCredentials() # ProjectIdCredentials | 
    origin = 'origin_example' # str |  (optional)
    referer = 'referer_example' # str |  (optional)

    try:
        # Enable required Google Cloud APIs
        api_response = await api_instance.setup_api_enable_api_services(project_id_credentials, origin=origin, referer=referer)
        print("The response of CorrectProjectApi->setup_api_enable_api_services:\n")
        pprint(api_response)
    except ApiException as e:
        print("Exception when calling CorrectProjectApi->setup_api_enable_api_services: %s\n" % e)

```

## Documentation for API Endpoints

All URIs are relative to *http://localhost*

Class | Method | HTTP request | Description
------------ | ------------- | ------------- | -------------
*CorrectProjectApi* | [**setup_api_enable_api_services**](docs/CorrectProjectApi.md#setup_api_enable_api_services) | **POST** /v1/correction/services/enable | Enable required Google Cloud APIs
*CorrectProjectApi* | [**setup_api_get_all_iap**](docs/CorrectProjectApi.md#setup_api_get_all_iap) | **POST** /v1/correction/iap/list | List all in-app products
*CorrectProjectApi* | [**setup_api_get_app_configs**](docs/CorrectProjectApi.md#setup_api_get_app_configs) | **POST** /v1/correction/firebase/app/config/list | Get app configurations
*CorrectProjectApi* | [**setup_api_get_app_version**](docs/CorrectProjectApi.md#setup_api_get_app_version) | **POST** /v1/correction/app/version | Get app version from Google Play
*CorrectProjectApi* | [**setup_api_update_iam_policy**](docs/CorrectProjectApi.md#setup_api_update_iam_policy) | **POST** /v1/correction/iam_policy/update | Update IAM policy for project
*DefaultApi* | [**default_health_check**](docs/DefaultApi.md#default_health_check) | **GET** / | Health Check
*DefaultApi* | [**default_metrics**](docs/DefaultApi.md#default_metrics) | **GET** /metrics | Metrics
*SetupApiApi* | [**setup_api_create_project_by_oauth**](docs/SetupApiApi.md#setup_api_create_project_by_oauth) | **POST** /v1/project/create | Create project using OAuth2 token
*SetupApiApi* | [**setup_api_enable_api_services**](docs/SetupApiApi.md#setup_api_enable_api_services) | **POST** /v1/correction/services/enable | Enable required Google Cloud APIs
*SetupApiApi* | [**setup_api_fill_app_information**](docs/SetupApiApi.md#setup_api_fill_app_information) | **POST** /v1/app/setup | Fill app information
*SetupApiApi* | [**setup_api_get_all_iap**](docs/SetupApiApi.md#setup_api_get_all_iap) | **POST** /v1/correction/iap/list | List all in-app products
*SetupApiApi* | [**setup_api_get_app_configs**](docs/SetupApiApi.md#setup_api_get_app_configs) | **POST** /v1/correction/firebase/app/config/list | Get app configurations
*SetupApiApi* | [**setup_api_get_app_version**](docs/SetupApiApi.md#setup_api_get_app_version) | **POST** /v1/correction/app/version | Get app version from Google Play
*SetupApiApi* | [**setup_api_update_iam_policy**](docs/SetupApiApi.md#setup_api_update_iam_policy) | **POST** /v1/correction/iam_policy/update | Update IAM policy for project
*SetupAppApi* | [**setup_api_fill_app_information**](docs/SetupAppApi.md#setup_api_fill_app_information) | **POST** /v1/app/setup | Fill app information
*SetupProjectApi* | [**setup_api_create_project_by_oauth**](docs/SetupProjectApi.md#setup_api_create_project_by_oauth) | **POST** /v1/project/create | Create project using OAuth2 token


## Documentation For Models

 - [ASCCredentials](docs/ASCCredentials.md)
 - [AndroidPublisherRelease](docs/AndroidPublisherRelease.md)
 - [AndroidPublisherTrack](docs/AndroidPublisherTrack.md)
 - [AndroidVersions](docs/AndroidVersions.md)
 - [BundleIdCredentials](docs/BundleIdCredentials.md)
 - [FirebaseAppConfigResponse](docs/FirebaseAppConfigResponse.md)
 - [GetFirebaseAppConfigPayload](docs/GetFirebaseAppConfigPayload.md)
 - [HTTPValidationError](docs/HTTPValidationError.md)
 - [IAPProducts](docs/IAPProducts.md)
 - [LanguageCode](docs/LanguageCode.md)
 - [Platform](docs/Platform.md)
 - [Product](docs/Product.md)
 - [ProjectByOauth](docs/ProjectByOauth.md)
 - [ProjectIdCredentials](docs/ProjectIdCredentials.md)
 - [PurchaseType](docs/PurchaseType.md)
 - [SetupAppData](docs/SetupAppData.md)
 - [Status](docs/Status.md)
 - [ValidationError](docs/ValidationError.md)
 - [ValidationErrorLocInner](docs/ValidationErrorLocInner.md)
 - [WrappedResponseAndroidVersions](docs/WrappedResponseAndroidVersions.md)
 - [WrappedResponseBool](docs/WrappedResponseBool.md)
 - [WrappedResponseListFirebaseAppConfigResponse](docs/WrappedResponseListFirebaseAppConfigResponse.md)
 - [WrappedResponseListIAPProducts](docs/WrappedResponseListIAPProducts.md)
 - [WrappedResponseUnionStrNoneType](docs/WrappedResponseUnionStrNoneType.md)


<a id="documentation-for-authorization"></a>
## Documentation For Authorization


Authentication schemes defined for the API:
<a id="Bearer Authorization"></a>
### Bearer Authorization

- **Type**: Bearer authentication


## Author




