#  Copyright (C) 2021
#  ABM, Moscow
#
#  UNPUBLISHED PROPRIETARY MATERIAL.
#  ALL RIGHTS RESERVED.
#
#  Authors: Mike Orlov <m.orlov@abm-jsc.ru>
#
import json
import logging
from typing import Mapping, Optional

from aiohttp import BasicAuth
from aiohttp.web_exceptions import HTTPServiceUnavailable
from init_helpers.custom_json import custom_dumps, Jsonable

from http_tools.http_server_connector import HttpServerConnector

logger = logging.getLogger(__name__)

DEFAULT_PROTOCOL = "http"
PROTOCOL_SEPARATOR = "://"


class AbmServiceConnector(HttpServerConnector):
    def __init__(self, config: HttpServerConnector.Config, context: HttpServerConnector.Context):
        super().__init__(config, context)

    async def post(self, path: str, payload: Jsonable, url_query: Mapping = None,
                   headers: Optional[Mapping[str, str]] = None, auth: Optional[BasicAuth] = None):
        jsom_payload = custom_dumps(payload)
        payload = json.loads(jsom_payload)

        result = await super().post_json(path, payload, url_query, headers)

        try:
            if result['done']:
                return result.get("result")
            else:
                raise HTTPServiceUnavailable(reason=result["error"])
        except KeyError as e:
            raise HTTPServiceUnavailable(reason=f"Incorrect answer from server: {result}") from e
