from enum import Enum
from aiohttp import MultipartReader

from .attached_file import AttachedFile
from .mime_types import ContentType


class MultipartHeaders(str, Enum):
    name = "name"
    filename = "filename"
    content_type = 'Content-Type'


async def parse_multipart_form_data(reader: MultipartReader):
    multipart_key_value = {}

    async for part in reader:
        part_content_type = part.headers.get(MultipartHeaders.content_type, ContentType.Text)

        if part.filename:
            file = AttachedFile(bytes(await part.read()), part.filename, part_content_type)
            multipart_key_value.setdefault("attached_files", []).append(file)
            multipart_key_value[part.name] = file
        else:
            if part_content_type == ContentType.Text:
                content = await part.text()
            elif part_content_type == ContentType.Json:
                content = await part.json()
            else:
                content = await part.read()
            multipart_key_value[part.name] = content

    return multipart_key_value
