#  Copyright (C) 2021
#  ABM, Moscow
#
#  UNPUBLISHED PROPRIETARY MATERIAL.
#  ALL RIGHTS RESERVED.
#
#  Authors: Mike Orlov <m.orlov@abm-jsc.ru>
#
from typing import Tuple, Dict

from http_tools.mime_types import ContentType


def parse_content_type_header(content_type_header: str) -> Tuple[ContentType, Dict[str, str]]:
    content_type_header_parts = content_type_header.split(';')
    content_type = ContentType(content_type_header_parts.pop(0))
    content_type_info = {}
    for info in content_type_header_parts:
        info_parts = info.strip().split("=", 1)
        content_type_info[info_parts[0]] = info_parts[1] if len(info_parts) > 1 else ''
    return content_type, content_type_info
