#  Copyright (C) 2021
#  ABM, Moscow
#
#  UNPUBLISHED PROPRIETARY MATERIAL.
#  ALL RIGHTS RESERVED.
#
#  Authors: Mike Orlov <m.orlov@abm-jsc.ru>
#
import abc
from typing import Optional, Mapping, Any

from init_helpers.custom_json import Jsonable

from ..abm_service_connector import AbmServiceConnector


class AbmServiceAuthedConnector(abc.ABC):
    Config = AbmServiceConnector.Config
    Context = AbmServiceConnector.Context

    def __init__(self, config: Config, context: Context) -> None:
        self._connector = AbmServiceConnector(config, context)

    @abc.abstractmethod
    async def get(self,
                  path: str,
                  url_query: Optional[Mapping[str, Any]] = None,
                  headers: Optional[Mapping[str, str]] = None,
                  token: str = None,
                  timeout_sec: Optional[float] = None) -> Any:
        pass

    @abc.abstractmethod
    async def post(self,
                   path: str,
                   payload: bytes | Jsonable,
                   url_query: Optional[Mapping[str, Any]] = None,
                   headers: Optional[Mapping[str, str]] = None,
                   token: str = None,
                   timeout_sec: Optional[float] = None) -> Any:
        pass
