#  Copyright (C) 2021
#  ABM, Moscow
#
#  UNPUBLISHED PROPRIETARY MATERIAL.
#  ALL RIGHTS RESERVED.
#
#  Authors: Mike Orlov <m.orlov@abm-jsc.ru>
#
from typing import TypeVar, MutableMapping, Callable, List, Set

from init_helpers.is_none import is_not_none


T = TypeVar('T')
Condition = Callable[[T], bool]


def conditional_set(mapping: MutableMapping, *, _condition: Condition = is_not_none, **kwargs: T) -> None:
    for key, value in kwargs.items():
        if _condition(value):
            mapping[key] = value


def conditional_append(list_: List, *args: T, _condition: Condition = is_not_none) -> None:
    for value in args:
        if _condition(value):
            list_.append(value)


def conditional_add(set_: Set, *args: T, _condition: Condition = is_not_none) -> None:
    for value in args:
        if _condition(value):
            set_.add(value)
