#  Copyright (C) 2021
#  ABM, Moscow
#
#  UNPUBLISHED PROPRIETARY MATERIAL.
#  ALL RIGHTS RESERVED.
#
#  Authors: Mike Orlov <m.orlov@abm-jsc.ru>
#
from configparser import ConfigParser
from typing import Dict


def read_ini_file_by_path(path: str) -> Dict[str, Dict[str, str]]:
    config = ConfigParser()
    config.read(path)
    return {name: {key: config[name][key] for key in config[name]} for name in config.sections()}
