#  Copyright (C) 2021
#  ABM, Moscow
#
#  UNPUBLISHED PROPRIETARY MATERIAL.
#  ALL RIGHTS RESERVED.
#
#  Authors: Mike Orlov <m.orlov@abm-jsc.ru>
#
import logging
import pathlib
import tomllib
from typing import Dict

logger = logging.getLogger(__file__)


def read_toml_file_by_path(path: str) -> Dict[str, Dict[str, str]]:
    logger.info(f"Attempt to read toml file by {path=}")
    text = pathlib.Path(path).read_text()
    return tomllib.loads(text)
