#  Copyright (C) 2025
#  ABM, Moscow
#
#  UNPUBLISHED PROPRIETARY MATERIAL.
#  ALL RIGHTS RESERVED.
#
#  Authors: Mike Orlov <m.orlov@abm-jsc.ru>
import typing

note = typing.Annotated
Type = typing.TypeVar("Type", bound=type)


def try_extract_type_notes(value: typing.Annotated | Type) -> tuple[Type, tuple]:
    if typing.get_origin(value) != typing.Annotated:
        return value, tuple()
    args = typing.get_args(value)
    return args[0], args[1:]
