#  Copyright (C) 2024
#  ABM, Moscow
#
#  UNPUBLISHED PROPRIETARY MATERIAL.
#  ALL RIGHTS RESERVED.
#
#  Authors: Mike Orlov <m.orlov@abm-jsc.ru>

def update_dict_recursive(target_dict: dict, source_dict: dict) -> None:
    for key, value in source_dict.items():
        if isinstance(value, dict) and isinstance(target_value := target_dict.get(key), dict):
            update_dict_recursive(target_value, value)
        else:
            target_dict[key] = value

