#  Copyright (C) 2026
#  ABM, Moscow
#
#  UNPUBLISHED PROPRIETARY MATERIAL.
#  ALL RIGHTS RESERVED.
#
#  Authors: Mike Orlov <m.orlov@abm-jsc.ru>
from typing import Any


def add_if(condition: bool, set_: set[Any], *args: Any) -> None:
    """
    if condition is True, add all values to set
    >>> add_if(True, s := {0}, 1, 2, 3)
    >>> s
    {0, 1, 2, 3}
    >>> add_if(False, s := {0}, 1, 2, 3)
    >>> s
    {0}
    """
    if condition:
        for value in args:
            set_.add(value)
