#  Copyright (C) 2026
#  ABM, Moscow
#
#  UNPUBLISHED PROPRIETARY MATERIAL.
#  ALL RIGHTS RESERVED.
#
#  Authors: Mike Orlov <m.orlov@abm-jsc.ru>
from typing import Any


def append_if(condition: bool, list_: list[Any], *args: Any) -> None:
    """
    if condition is True, append all values to list
    >>> append_if(True, l := [0], 1, 2, 3)
    >>> l
    [0, 1, 2, 3]
    >>> append_if(False, l := [0], 1, 2, 3)
    >>> l
    [0]
    """
    if condition:
        for value in args:
            list_.append(value)
