#  Copyright (C) 2026
#  ABM, Moscow
#
#  UNPUBLISHED PROPRIETARY MATERIAL.
#  ALL RIGHTS RESERVED.
#
#  Authors: Mike Orlov <m.orlov@abm-jsc.ru>
from typing import TypeVar, Callable

from init_helpers._conditional.is_none import is_not_none

T = TypeVar('T')
Condition = Callable[[T], bool]


def conditional_append(list_: list, *args: T, _condition: Condition = is_not_none) -> None:
    for value in args:
        if _condition(value):
            list_.append(value)
