#  Copyright (C) 2026
#  ABM, Moscow
#
#  UNPUBLISHED PROPRIETARY MATERIAL.
#  ALL RIGHTS RESERVED.
#
#  Authors: Mike Orlov <m.orlov@abm-jsc.ru>
from typing import TypeVar, MutableMapping, Callable, Any

from typing_extensions import deprecated

from init_helpers._conditional.is_none import is_not_none


T = TypeVar('T')
Condition = Callable[[T], bool]


def conditional_setitem(mapping: MutableMapping[str, Any], *, _condition: Condition = is_not_none, **kwargs: T) -> None:
    for key, value in kwargs.items():
        if _condition(value):
            mapping[key] = value


@deprecated('Use conditional_setitem instead')
def conditional_set(mapping: MutableMapping[str, Any], *, _condition: Condition = is_not_none, **kwargs: T) -> None:
    return conditional_setitem(mapping, _condition=_condition, **kwargs)
