#  Copyright (C) 2026
#  ABM, Moscow
#
#  UNPUBLISHED PROPRIETARY MATERIAL.
#  ALL RIGHTS RESERVED.
#
#  Authors: Mike Orlov <m.orlov@abm-jsc.ru>
from typing import MutableMapping, Any

from typing_extensions import deprecated


def setitem_if(condition: bool, mapping: MutableMapping[str, Any], **kwargs: Any) -> None:
    """
    if condition is True, set all items in mapping
    >>> setitem_if(True, d := {'q': 1}, w=2, e=3)
    >>> d
    {'q': 1, 'w': 2, 'e': 3}
    >>> setitem_if(False, d := {'q': 1}, w=2, e=3)
    >>> d
    {'q': 1}
    """
    if condition:
        for key, value in kwargs.items():
            mapping[key] = value


@deprecated('Use setitem_if instead')
def set_if(condition: bool, mapping: MutableMapping[str, Any], **kwargs: Any) -> None:
    return setitem_if(condition=condition, mapping=mapping, **kwargs)
