#  Copyright (C) 2026
#  ABM, Moscow
#
#  UNPUBLISHED PROPRIETARY MATERIAL.
#  ALL RIGHTS RESERVED.
#
#  Authors: Mike Orlov <m.orlov@abm-jsc.ru>
import os
import pathlib


class FileTextReadingFailure(Exception):
    pass


def read_file_text(path: str | pathlib.Path | os.PathLike, encoding: str | None = None) -> str:
    if not path:
        raise FileTextReadingFailure(f"Got empty path to read: {path=}")
    try:
        prepared_path = pathlib.Path(path)
    except Exception as e:
        raise FileTextReadingFailure(f"Failed to cast {path=} to pathlib.Path: {e=}") from None

    if not prepared_path.exists():
        raise FileTextReadingFailure(f"No file found by {path=}")
    if not prepared_path.is_file():
        raise FileTextReadingFailure(f"{path=} leads to non file object")
    try:
        return prepared_path.read_text(encoding=encoding)
    except Exception as e:
        raise FileTextReadingFailure(f"Failed to read text from file by {path=}: {e=}") from None
