#  Copyright (C) 2026
#  ABM, Moscow
#
#  UNPUBLISHED PROPRIETARY MATERIAL.
#  ALL RIGHTS RESERVED.
#
#  Authors: Mike Orlov <m.orlov@abm-jsc.ru>
import dataclasses
import types
from dataclasses import dataclass
from typing import Any


@dataclass(slots=True, frozen=True)
class FieldHint:
    name: str
    type: type | types.UnionType | dataclasses.InitVar  # | typing.Union
    default: Any = dataclasses.field(default_factory=lambda: dataclasses.MISSING)

    def __eq__(self, other: 'FieldHint') -> bool:
        """
        InitVar[str] != InitVar[str], so distinct type check is required
        """
        if (not isinstance(other, FieldHint) or self.name != other.name or
                type(self.type) != type(self.type) or self.default != other.default):
            return False
        if isinstance(self.type, dataclasses.InitVar):
            return self.type.type == other.type.type
        return self.type == other.type

    def __repr__(self) -> str:
        parts = [f'name={self.name!r}'] + [f'type={self.type.__name__ if isinstance(self.type, type) else self.type}']
        parts += [] if self.default is dataclasses.MISSING else [f'default={self.default!r}']
        return f'{type(self).__name__}({", ".join(parts)})'

    __str__ = __repr__
