#  Copyright (C) 2026
#  ABM, Moscow
#
#  UNPUBLISHED PROPRIETARY MATERIAL.
#  ALL RIGHTS RESERVED.
#
#  Authors: Mike Orlov <m.orlov@abm-jsc.ru>
import dataclasses

from .structure_hint import StructureHint
from .field_hint import FieldHint
from .._dataclass import get_dataclass_field_name_to_field


def get_hint_from_dataclass(dataclass_type: type) -> StructureHint:
    if not dataclasses.is_dataclass(dataclass_type):
        raise TypeError("expected dataclass type")

    args = []
    dataclass_fields = get_dataclass_field_name_to_field(dataclass_type)
    for field_name in dataclass_fields:
        field = dataclass_fields[field_name]
        if not field.init:
            continue

        default = dataclasses.MISSING
        if field.default != dataclasses.MISSING:
            default = field.default
        elif field.default_factory != dataclasses.MISSING:
            default = field.default_factory

        field_type = field.type
        if dataclasses.is_dataclass(field_type):
            hint = get_hint_from_dataclass(field_type)
            hint = dataclasses.replace(hint, name=field_name)
        else:
            hint = FieldHint(field_name, field_type, default)

        args.append(hint)
    return StructureHint(args)
