#  Copyright (C) 2026
#  ABM, Moscow
#
#  UNPUBLISHED PROPRIETARY MATERIAL.
#  ALL RIGHTS RESERVED.
#
#  Authors: Mike Orlov <m.orlov@abm-jsc.ru>
import collections.abc
from dataclasses import dataclass


@dataclass(slots=True, frozen=True)
class StructureHint:
    fields: collections.abc.Sequence['FieldHint | StructureHint']
    name: str | None = None

    def __post_init__(self):
        object.__setattr__(self, 'fields', tuple(self.fields))

    def __repr__(self) -> str:
        parts = [] if self.name is None else [f'name={self.name!r}']
        parts += [f'fields={list(self.fields)}']
        return f'{type(self).__name__}({", ".join(parts)})'

    __str__ = __repr__
