#  Copyright (C) 2026
#  ABM, Moscow
#
#  UNPUBLISHED PROPRIETARY MATERIAL.
#  ALL RIGHTS RESERVED.
#
#  Authors: Mike Orlov <m.orlov@abm-jsc.ru>
import configparser

from ._exceptions import IniParseError


def parse_ini_content(ini_content: str) -> dict[str, dict[str, str]]:
    config = configparser.RawConfigParser()
    try:
        config.read_string(ini_content)
    except configparser.Error as e:
        raise IniParseError(f"Failed to parse {ini_content=} as dict: {e=}") from None
    return {name: {key: config[name][key] for key in config[name]} for name in config.sections()}
