#  Copyright (C) 2021
#  ABM, Moscow
#
#  UNPUBLISHED PROPRIETARY MATERIAL.
#  ALL RIGHTS RESERVED.
#
#  Authors: Mike Orlov <m.orlov@abm-jsc.ru>
#
import logging
import os
import pathlib

from .parse_ini_content import parse_ini_content
from .._file.read_file_text import read_file_text

logger = logging.getLogger(__file__)


def read_ini_file_by_path(
        path: str | pathlib.Path | os.PathLike, encoding: str | None = None
) -> dict[str, dict[str, str]]:
    logger.info(f"Attempt to read ini file by {path=}")
    return parse_ini_content(read_file_text(path=path, encoding=encoding))
