#  Copyright (C) 2024
#  ABM, Moscow
#
#  UNPUBLISHED PROPRIETARY MATERIAL.
#  ALL RIGHTS RESERVED.
#
#  Authors: Mike Orlov <m.orlov@abm-jsc.ru>
import os
import random
import time

from init_helpers.no_value import NoValue


def init_random(
        seed: None | int | float | str | bytes | bytearray | NoValue
) -> None | int | float | str | bytes | bytearray:
    seed = os.getpid() + time.time() if seed is NoValue else seed
    random.seed(seed)
    return seed
