#  Copyright (C) 2024
#  ABM, Moscow
#
#  UNPUBLISHED PROPRIETARY MATERIAL.
#  ALL RIGHTS RESERVED.
#
#  Authors: Mike Orlov <m.orlov@abm-jsc.ru>
import argparse
from typing import TypeVar, Iterable

from .read_config import read_config
from .._cast import unflatten_dict
from .._dataclass import dict_to_dataclass
from .._utils import update_dict_recursive
from .._type import DataclassProtocol

DP = TypeVar('DP', bound=DataclassProtocol)


def parse_args_as_dataclass(dataclass_type: type[DP], flag_name: str = '-v', args: Iterable[str] | None = None) -> DP:
    parser = argparse.ArgumentParser()
    parser.add_argument('config_file_path', nargs='?', default=None)
    overload_arg = parser.add_argument(flag_name, action='append')
    parsed = parser.parse_args(args)
    config = read_config(parsed.config_file_path) if parsed.config_file_path else {}
    raw_overload = getattr(parsed, overload_arg.dest) or []
    overload: dict[str, str | dict[str, str | dict]] = unflatten_dict(dict([val.split('=') for val in raw_overload]))
    update_dict_recursive(config, overload)
    return dict_to_dataclass(config, dataclass_type)
