#  Copyright (C) 2026
#  ABM, Moscow
#
#  UNPUBLISHED PROPRIETARY MATERIAL.
#  ALL RIGHTS RESERVED.
#
#  Authors: Mike Orlov <m.orlov@abm-jsc.ru>
from .._toml import read_toml_file_by_path
from .._ini import read_ini_file_by_path


def read_config(config_file_path: str) -> dict[str, dict[str, str]]:
    extension = config_file_path.rsplit('.', 1)[-1]
    if extension == 'toml':
        return read_toml_file_by_path(config_file_path)
    if extension == 'ini':
        return read_ini_file_by_path(config_file_path)
    raise TypeError(f'Unknown {extension=}')
