#  Copyright (C) 2024
#  ABM, Moscow
#
#  UNPUBLISHED PROPRIETARY MATERIAL.
#  ALL RIGHTS RESERVED.
#
#  Authors: Mike Orlov <m.orlov@abm-jsc.ru>
import string

from .instance_id_config import InstanceIdConfig
from .parsed_abm_url import ParsedAbmUrl


async def get_instance_id(config: InstanceIdConfig, **kwargs) -> str:
    keys_required = {i[1] for i in string.Formatter().parse(config.instance_id_template) if i[1] is not None}
    if missing_keys := keys_required - config.template_keyword_to_abm_url.keys():
        raise KeyError(f'Missing keywords: {missing_keys}') from None
    return config.instance_id_template.format_map({
        key: await ParsedAbmUrl.from_str(config.template_keyword_to_abm_url[key]).get(**kwargs) for key in keys_required
    })
