#  Copyright (C) 2026
#  ABM, Moscow
#
#  UNPUBLISHED PROPRIETARY MATERIAL.
#  ALL RIGHTS RESERVED.
#
#  Authors: Mike Orlov <m.orlov@abm-jsc.ru>
from dataclasses import dataclass, field


@dataclass(frozen=True, slots=True)
class InstanceIdConfig:
    instance_id_template: str = "service:{company}/{group}/{project}, built:{build}, host:{host}, user:{user}, run:{started_at}"
    # instance_id_template: str = "{company}:{group}:{project}::{build}:{environment}({shard_id}){started_at}"
    template_keyword_to_abm_url: dict[str, str] = field(default_factory=lambda: {
        "company": "kwargs://context|_.company",
        "group": "kwargs://context|_.project_group",
        "project": "kwargs://context|_.project_name",
        "build": "import://build_info|_.build_id",
        "environment": "envvar://ENVIRONMENT",
        "shard_id": "envvar://SHARD_ID",
        "started_at":
            "none://|__import__('datetime').datetime.now(__import__('datetime').timezone.utc).astimezone().isoformat()",
        "host": "none://|__import__('socket').gethostname()",
        "user": "none://|__import__('getpass').getuser()",
    })
