#  Copyright (C) 2026
#  ABM, Moscow
#
#  UNPUBLISHED PROPRIETARY MATERIAL.
#  ALL RIGHTS RESERVED.
#
#  Authors: Mike Orlov <m.orlov@abm-jsc.ru>
import datetime
from decimal import Decimal
from typing import TypeAlias, Union

from .repr_in_dumps import ReprInDumps
from .._type import DataclassProtocol

JsonLoaded: TypeAlias = Union[list['JsonLoaded'], dict[str, 'JsonLoaded'], str, int, float, None]
Jsonable: TypeAlias = Union[JsonLoaded, list['Jsonable'], tuple['Jsonable', ...], dict[str | int, 'Jsonable']]
CustomJsonable: TypeAlias = Union[
    Jsonable, list['CustomJsonable'], tuple['CustomJsonable', ...], dict[str | int, 'CustomJsonable'],
    set['CustomJsonable'], frozenset['CustomJsonable'],
    bytes, ReprInDumps, type, DataclassProtocol, datetime.datetime, datetime.date, datetime.time, Decimal, Exception
]
