#  Copyright (C) 2024
#  ABM, Moscow
#
#  UNPUBLISHED PROPRIETARY MATERIAL.
#  ALL RIGHTS RESERVED.
#
#  Authors: Mike Orlov <m.orlov@abm-jsc.ru>
from typing import Any, Mapping, MutableMapping


def update_dict_recursive(target_dict: MutableMapping[str, Any], source_dict: Mapping[str, Any]) -> None:
    for key, value in source_dict.items():
        if isinstance(value, dict) and isinstance(target_value := target_dict.get(key), dict):
            update_dict_recursive(target_value, value)
        else:
            target_dict[key] = value
