# internal-integration-handler-connector
Mentortools service for handling internal integrations

This Python package is automatically generated by the [OpenAPI Generator](https://openapi-generator.tech) project:

- API version: 0.1.0
- Package version: 1.0.2+2060073775
- Generator version: 7.14.0
- Build package: org.openapitools.codegen.languages.PythonPydanticV1ClientCodegen

## Requirements.

Python 3.7+

## Installation & Usage
### pip install

If the python package is hosted on a repository, you can install directly using:

```sh
pip install git+https://github.com/GIT_USER_ID/GIT_REPO_ID.git
```
(you may need to run `pip` with root permission: `sudo pip install git+https://github.com/GIT_USER_ID/GIT_REPO_ID.git`)

Then import the package:
```python
import internal_integration_handler_connector
```

### Setuptools

Install via [Setuptools](http://pypi.python.org/pypi/setuptools).

```sh
python setup.py install --user
```
(or `sudo python setup.py install` to install the package for all users)

Then import the package:
```python
import internal_integration_handler_connector
```

### Tests

Execute `pytest` to run the tests.

## Getting Started

Please follow the [installation procedure](#installation--usage) and then run the following:

```python

import time
import internal_integration_handler_connector
from internal_integration_handler_connector.rest import ApiException
from pprint import pprint

# Defining the host is optional and defaults to http://localhost
# See configuration.py for a list of all supported configuration parameters.
configuration = internal_integration_handler_connector.Configuration(
    host = "http://localhost"
)



# Enter a context with an instance of the API client
async with internal_integration_handler_connector.ApiClient(configuration) as api_client:
    # Create an instance of the API class
    api_instance = internal_integration_handler_connector.DefaultApi(api_client)

    try:
        # Health Check
        api_response = await api_instance.default_health_check()
        print("The response of DefaultApi->default_health_check:\n")
        pprint(api_response)
    except ApiException as e:
        print("Exception when calling DefaultApi->default_health_check: %s\n" % e)

```

## Documentation for API Endpoints

All URIs are relative to *http://localhost*

Class | Method | HTTP request | Description
------------ | ------------- | ------------- | -------------
*DefaultApi* | [**default_health_check**](docs/DefaultApi.md#default_health_check) | **GET** / | Health Check
*InternalIntegrationsApi* | [**internal_integrations_add_lesson_from_stream_recording**](docs/InternalIntegrationsApi.md#internal_integrations_add_lesson_from_stream_recording) | **POST** /v1/integration/add_lesson_from_stream_recording | Add Lesson From Stream Recording
*InternalIntegrationsApi* | [**internal_integrations_add_user_to_group_chat**](docs/InternalIntegrationsApi.md#internal_integrations_add_user_to_group_chat) | **POST** /v1/integration/add_user_to_group_chat | Add User To Group Chat
*InternalIntegrationsApi* | [**internal_integrations_remove_user_from_group_chat**](docs/InternalIntegrationsApi.md#internal_integrations_remove_user_from_group_chat) | **POST** /v1/integration/remove_user_from_group_chat | Remove User From Group Chat
*InternalIntegrationsApi* | [**internal_integrations_send_chat_message_to_group_chat**](docs/InternalIntegrationsApi.md#internal_integrations_send_chat_message_to_group_chat) | **POST** /v1/integration/send_chat_message_to_group_chat | Send Chat Message To Group Chat
*InternalIntegrationsApi* | [**internal_integrations_send_personal_chat_message**](docs/InternalIntegrationsApi.md#internal_integrations_send_personal_chat_message) | **POST** /v1/integration/send_personal_chat_message | Send Personal Chat Message


## Documentation For Models

 - [AddNewStreamRecordingToModule](docs/AddNewStreamRecordingToModule.md)
 - [AddUserToGroupChat](docs/AddUserToGroupChat.md)
 - [HTTPValidationError](docs/HTTPValidationError.md)
 - [PortalMember](docs/PortalMember.md)
 - [RemoveUserFromGroupChat](docs/RemoveUserFromGroupChat.md)
 - [ResponseWrapper](docs/ResponseWrapper.md)
 - [ResponseWrapperBool](docs/ResponseWrapperBool.md)
 - [ResponseWrapperInt](docs/ResponseWrapperInt.md)
 - [Result](docs/Result.md)
 - [SendMessageInGroupChat](docs/SendMessageInGroupChat.md)
 - [SendPersonalMessageToUser](docs/SendPersonalMessageToUser.md)
 - [ValidationError](docs/ValidationError.md)
 - [ValidationErrorLocInner](docs/ValidationErrorLocInner.md)


<a id="documentation-for-authorization"></a>
## Documentation For Authorization


Authentication schemes defined for the API:
<a id="APIKeyHeader"></a>
### APIKeyHeader

- **Type**: API key
- **API key parameter name**: server_name
- **Location**: HTTP header


## Author




