#  Copyright (C) 2022
#  ABM, Moscow
#
#  UNPUBLISHED PROPRIETARY MATERIAL.
#  ALL RIGHTS RESERVED.
#
#  Authors: Vasiliev Ivan <i.vasiliev@technokert.ru>

# Copyright (C) 2021
# ABM, Moscow

# UNPUBLISHED PROPRIETARY MATERIAL.
# ALL RIGHTS RESERVED.

# Authors: Vasiliev Ivan <i.vasiliev@abm-jsc.ru>

import asyncio
import logging
from abc import ABC, abstractmethod
from asyncio import Task
from dataclasses import dataclass

from async_tools import AsyncOnStop, AsyncOnStart
from typing import Optional

logger = logging.getLogger(__file__)


class AbstractKafkaClient(ABC, AsyncOnStart, AsyncOnStop):
    @dataclass(frozen=True)
    class Config:
        address: str

    def __init__(self, config: Config) -> None:
        self.config = config
        self.__start_task: Optional[Task] = None
        self.__disconnect_task: Optional[Task] = None
        self.__inited_event = asyncio.Event()
        self.__on_start_called = False
        self.__on_stop_called = False

    async def _on_start(self) -> None:
        # TODO add skip several _on_start calls functional to AsyncOnStop
        if self.__on_start_called:
            return
        logger.info(f"{type(self).__name__} _on_start")
        await self.start()
        self.__on_start_called = True

    async def _on_stop(self) -> None:
        # TODO add skip several _on_stop calls functional to AsyncOnStop

        if self.__on_stop_called:
            return
        logger.info(f"{type(self).__name__} _on_stop")
        await self.disconnect()
        self.__on_stop_called = True

    # TODO add reconnect

    async def disconnect(self) -> None:
        await self._disconnect()

    @abstractmethod
    async def _disconnect(self) -> None:
        pass

    async def start(self) -> None:
        await self._start()
        self.__inited_event.set()

    @abstractmethod
    async def _start(self) -> None:
        pass

    async def wait_connect(self) -> None:
        await self.__inited_event.wait()

    def is_connected(self) -> bool:
        return self.__inited_event.is_set()
