# coding: utf-8

"""
    Mentortools Landing Page API

    Mentortools service for building and publishing landing pages

    The version of the OpenAPI document: 0.1.0
    Generated by OpenAPI Generator (https://openapi-generator.tech)

    Do not edit the class manually.
"""  # noqa: E501


from __future__ import annotations
import pprint
import re  # noqa: F401
import json


from typing import Optional
from pydantic import BaseModel, Field, StrictStr
from landing_page_server_connector.models.address import Address

class FormSubmitRequest(BaseModel):
    """
    FormSubmitRequest
    """
    uuid: StrictStr = Field(...)
    email: StrictStr = Field(...)
    first_name: Optional[StrictStr] = None
    last_name: Optional[StrictStr] = None
    phone_number: Optional[StrictStr] = None
    company: Optional[StrictStr] = None
    nickname: Optional[StrictStr] = None
    address: Optional[Address] = None
    __properties = ["uuid", "email", "first_name", "last_name", "phone_number", "company", "nickname", "address"]

    class Config:
        """Pydantic configuration"""
        allow_population_by_field_name = True
        validate_assignment = True

    def to_str(self) -> str:
        """Returns the string representation of the model using alias"""
        return pprint.pformat(self.dict(by_alias=True))

    def to_json(self) -> str:
        """Returns the JSON representation of the model using alias"""
        return json.dumps(self.to_dict())

    @classmethod
    def from_json(cls, json_str: str) -> FormSubmitRequest:
        """Create an instance of FormSubmitRequest from a JSON string"""
        return cls.from_dict(json.loads(json_str))

    def to_dict(self):
        """Returns the dictionary representation of the model using alias"""
        _dict = self.dict(by_alias=True,
                          exclude={
                          },
                          exclude_none=True)
        # override the default output from pydantic by calling `to_dict()` of address
        if self.address:
            _dict['address'] = self.address.to_dict()
        return _dict

    @classmethod
    def from_dict(cls, obj: dict) -> FormSubmitRequest:
        """Create an instance of FormSubmitRequest from a dict"""
        if obj is None:
            return None

        if not isinstance(obj, dict):
            return FormSubmitRequest.parse_obj(obj)

        _obj = FormSubmitRequest.parse_obj({
            "uuid": obj.get("uuid"),
            "email": obj.get("email"),
            "first_name": obj.get("first_name"),
            "last_name": obj.get("last_name"),
            "phone_number": obj.get("phone_number"),
            "company": obj.get("company"),
            "nickname": obj.get("nickname"),
            "address": Address.from_dict(obj.get("address")) if obj.get("address") is not None else None
        })
        return _obj


