# coding: utf-8

"""
    Mentortools Landing Page API

    Mentortools service for building and publishing landing pages

    The version of the OpenAPI document: 0.1.0
    Generated by OpenAPI Generator (https://openapi-generator.tech)

    Do not edit the class manually.
"""  # noqa: E501


from __future__ import annotations
import pprint
import re  # noqa: F401
import json


from typing import Optional
from pydantic import BaseModel, Field, StrictBool, StrictInt, StrictStr
from landing_page_server_connector.models.portal_language_enum import PortalLanguageEnum

class TemplateListGet(BaseModel):
    """
    TemplateListGet
    """
    id: StrictInt = Field(...)
    language_id: PortalLanguageEnum = Field(...)
    is_listed: StrictBool = Field(...)
    preview_id: Optional[StrictStr] = None
    name: StrictStr = Field(...)
    title: StrictStr = Field(...)
    path: StrictStr = Field(...)
    order: StrictInt = Field(...)
    created_at: StrictInt = Field(...)
    updated_at: Optional[StrictInt] = None
    published_at: Optional[StrictInt] = None
    deleted_at: Optional[StrictInt] = None
    __properties = ["id", "language_id", "is_listed", "preview_id", "name", "title", "path", "order", "created_at", "updated_at", "published_at", "deleted_at"]

    class Config:
        """Pydantic configuration"""
        allow_population_by_field_name = True
        validate_assignment = True

    def to_str(self) -> str:
        """Returns the string representation of the model using alias"""
        return pprint.pformat(self.dict(by_alias=True))

    def to_json(self) -> str:
        """Returns the JSON representation of the model using alias"""
        return json.dumps(self.to_dict())

    @classmethod
    def from_json(cls, json_str: str) -> TemplateListGet:
        """Create an instance of TemplateListGet from a JSON string"""
        return cls.from_dict(json.loads(json_str))

    def to_dict(self):
        """Returns the dictionary representation of the model using alias"""
        _dict = self.dict(by_alias=True,
                          exclude={
                          },
                          exclude_none=True)
        return _dict

    @classmethod
    def from_dict(cls, obj: dict) -> TemplateListGet:
        """Create an instance of TemplateListGet from a dict"""
        if obj is None:
            return None

        if not isinstance(obj, dict):
            return TemplateListGet.parse_obj(obj)

        _obj = TemplateListGet.parse_obj({
            "id": obj.get("id"),
            "language_id": obj.get("language_id"),
            "is_listed": obj.get("is_listed"),
            "preview_id": obj.get("preview_id"),
            "name": obj.get("name"),
            "title": obj.get("title"),
            "path": obj.get("path"),
            "order": obj.get("order"),
            "created_at": obj.get("created_at"),
            "updated_at": obj.get("updated_at"),
            "published_at": obj.get("published_at"),
            "deleted_at": obj.get("deleted_at")
        })
        return _obj


