# coding: utf-8

"""
    Mentortools Landing Page API

    Mentortools service for building and publishing landing pages

    The version of the OpenAPI document: 0.1.0
    Generated by OpenAPI Generator (https://openapi-generator.tech)

    Do not edit the class manually.
"""  # noqa: E501


from __future__ import annotations
import pprint
import re  # noqa: F401
import json


from typing import Any, Dict, List
from pydantic import BaseModel, Field, StrictInt, StrictStr, conlist

class LandingHistoryGet(BaseModel):
    """
    LandingHistoryGet
    """
    html: StrictStr = Field(...)
    css: StrictStr = Field(...)
    js: StrictStr = Field(...)
    components: Dict[str, Any] = Field(...)
    styles: conlist(Dict[str, Any]) = Field(...)
    assets: conlist(Dict[str, Any]) = Field(...)
    id: StrictInt = Field(...)
    created_at: StrictInt = Field(...)
    __properties = ["html", "css", "js", "components", "styles", "assets", "id", "created_at"]

    class Config:
        """Pydantic configuration"""
        allow_population_by_field_name = True
        validate_assignment = True

    def to_str(self) -> str:
        """Returns the string representation of the model using alias"""
        return pprint.pformat(self.dict(by_alias=True))

    def to_json(self) -> str:
        """Returns the JSON representation of the model using alias"""
        return json.dumps(self.to_dict())

    @classmethod
    def from_json(cls, json_str: str) -> LandingHistoryGet:
        """Create an instance of LandingHistoryGet from a JSON string"""
        return cls.from_dict(json.loads(json_str))

    def to_dict(self):
        """Returns the dictionary representation of the model using alias"""
        _dict = self.dict(by_alias=True,
                          exclude={
                          },
                          exclude_none=True)
        return _dict

    @classmethod
    def from_dict(cls, obj: dict) -> LandingHistoryGet:
        """Create an instance of LandingHistoryGet from a dict"""
        if obj is None:
            return None

        if not isinstance(obj, dict):
            return LandingHistoryGet.parse_obj(obj)

        _obj = LandingHistoryGet.parse_obj({
            "html": obj.get("html"),
            "css": obj.get("css"),
            "js": obj.get("js"),
            "components": obj.get("components"),
            "styles": obj.get("styles"),
            "assets": obj.get("assets"),
            "id": obj.get("id"),
            "created_at": obj.get("created_at")
        })
        return _obj


