# landing-page-server-connector
Mentortools public API service

This Python package is automatically generated by the [OpenAPI Generator](https://openapi-generator.tech) project:

- API version: 0.1.0
- Package version: 0.2.1+1927695596
- Generator version: 7.14.0
- Build package: org.openapitools.codegen.languages.PythonPydanticV1ClientCodegen

## Requirements.

Python 3.7+

## Installation & Usage
### pip install

If the python package is hosted on a repository, you can install directly using:

```sh
pip install git+https://github.com/GIT_USER_ID/GIT_REPO_ID.git
```
(you may need to run `pip` with root permission: `sudo pip install git+https://github.com/GIT_USER_ID/GIT_REPO_ID.git`)

Then import the package:
```python
import landing_page_server_connector
```

### Setuptools

Install via [Setuptools](http://pypi.python.org/pypi/setuptools).

```sh
python setup.py install --user
```
(or `sudo python setup.py install` to install the package for all users)

Then import the package:
```python
import landing_page_server_connector
```

### Tests

Execute `pytest` to run the tests.

## Getting Started

Please follow the [installation procedure](#installation--usage) and then run the following:

```python

import time
import landing_page_server_connector
from landing_page_server_connector.rest import ApiException
from pprint import pprint

# Defining the host is optional and defaults to http://localhost
# See configuration.py for a list of all supported configuration parameters.
configuration = landing_page_server_connector.Configuration(
    host = "http://localhost"
)

# The client must configure the authentication and authorization parameters
# in accordance with the API server security policy.
# Examples for each auth method are provided below, use the example that
# satisfies your auth use case.

# Configure API key authorization: APIKeyHeader
configuration.api_key['APIKeyHeader'] = os.environ["API_KEY"]

# Uncomment below to setup prefix (e.g. Bearer) for API key, if needed
# configuration.api_key_prefix['APIKeyHeader'] = 'Bearer'

# Configure Bearer authorization: HTTPBearer
configuration = landing_page_server_connector.Configuration(
    access_token = os.environ["BEARER_TOKEN"]
)


# Enter a context with an instance of the API client
async with landing_page_server_connector.ApiClient(configuration) as api_client:
    # Create an instance of the API class
    api_instance = landing_page_server_connector.DefaultApi(api_client)

    try:
        # Count Keys
        api_response = await api_instance.count_keys_api_keys_v1_count_get()
        print("The response of DefaultApi->count_keys_api_keys_v1_count_get:\n")
        pprint(api_response)
    except ApiException as e:
        print("Exception when calling DefaultApi->count_keys_api_keys_v1_count_get: %s\n" % e)

```

## Documentation for API Endpoints

All URIs are relative to *http://localhost*

Class | Method | HTTP request | Description
------------ | ------------- | ------------- | -------------
*DefaultApi* | [**count_keys_api_keys_v1_count_get**](docs/DefaultApi.md#count_keys_api_keys_v1_count_get) | **GET** /api_keys/v1/count | Count Keys
*DefaultApi* | [**count_logs_api_logs_v1_count_get**](docs/DefaultApi.md#count_logs_api_logs_v1_count_get) | **GET** /api_logs/v1/count | Count Logs
*DefaultApi* | [**count_permission_categories_api_keys_v1_permision_categories_count_get**](docs/DefaultApi.md#count_permission_categories_api_keys_v1_permision_categories_count_get) | **GET** /api_keys/v1/permision_categories/count | Count Permission Categories
*DefaultApi* | [**create_key_api_keys_v1_post**](docs/DefaultApi.md#create_key_api_keys_v1_post) | **POST** /api_keys/v1/ | Create Key
*DefaultApi* | [**delete_key_api_keys_v1_key_id_delete**](docs/DefaultApi.md#delete_key_api_keys_v1_key_id_delete) | **DELETE** /api_keys/v1/{key_id} | Delete Key
*DefaultApi* | [**get_key_api_keys_v1_key_id_get**](docs/DefaultApi.md#get_key_api_keys_v1_key_id_get) | **GET** /api_keys/v1/{key_id} | Get Key
*DefaultApi* | [**get_keys_api_keys_v1_get**](docs/DefaultApi.md#get_keys_api_keys_v1_get) | **GET** /api_keys/v1/ | Get Keys
*DefaultApi* | [**get_log_api_logs_v1_log_id_get**](docs/DefaultApi.md#get_log_api_logs_v1_log_id_get) | **GET** /api_logs/v1/{log_id} | Get Log
*DefaultApi* | [**get_logs_api_logs_v1_get**](docs/DefaultApi.md#get_logs_api_logs_v1_get) | **GET** /api_logs/v1/ | Get Logs
*DefaultApi* | [**get_permission_categories_api_keys_v1_permision_categories_get**](docs/DefaultApi.md#get_permission_categories_api_keys_v1_permision_categories_get) | **GET** /api_keys/v1/permision_categories | Get Permission Categories
*DefaultApi* | [**handle_ipn_ipn_v1_handle_post**](docs/DefaultApi.md#handle_ipn_ipn_v1_handle_post) | **POST** /ipn/v1/handle | Handle Ipn
*DefaultApi* | [**health_check_get**](docs/DefaultApi.md#health_check_get) | **GET** / | Health Check
*DefaultApi* | [**patch_key_api_keys_v1_key_id_patch**](docs/DefaultApi.md#patch_key_api_keys_v1_key_id_patch) | **PATCH** /api_keys/v1/{key_id} | Patch Key
*DefaultApi* | [**update_key_api_keys_v1_key_id_put**](docs/DefaultApi.md#update_key_api_keys_v1_key_id_put) | **PUT** /api_keys/v1/{key_id} | Update Key


## Documentation For Models

 - [ApiKeyCreate](docs/ApiKeyCreate.md)
 - [ApiKeyCreateResponse](docs/ApiKeyCreateResponse.md)
 - [ApiKeyGet](docs/ApiKeyGet.md)
 - [ApiKeyPatch](docs/ApiKeyPatch.md)
 - [ApiKeyUpdate](docs/ApiKeyUpdate.md)
 - [ApiLogGet](docs/ApiLogGet.md)
 - [CategoryPermissions](docs/CategoryPermissions.md)
 - [HTTPValidationError](docs/HTTPValidationError.md)
 - [HttpMethod](docs/HttpMethod.md)
 - [IpnPaymentRequest](docs/IpnPaymentRequest.md)
 - [ResponseWrapper](docs/ResponseWrapper.md)
 - [ResponseWrapperApiKeyCreateResponse](docs/ResponseWrapperApiKeyCreateResponse.md)
 - [ResponseWrapperApiKeyGet](docs/ResponseWrapperApiKeyGet.md)
 - [ResponseWrapperApiLogGet](docs/ResponseWrapperApiLogGet.md)
 - [ResponseWrapperBool](docs/ResponseWrapperBool.md)
 - [ResponseWrapperInt](docs/ResponseWrapperInt.md)
 - [ResponseWrapperListApiKeyGet](docs/ResponseWrapperListApiKeyGet.md)
 - [ResponseWrapperListApiLogGet](docs/ResponseWrapperListApiLogGet.md)
 - [ResponseWrapperListStr](docs/ResponseWrapperListStr.md)
 - [Result](docs/Result.md)
 - [ValidationError](docs/ValidationError.md)
 - [ValidationErrorLocInner](docs/ValidationErrorLocInner.md)


<a id="documentation-for-authorization"></a>
## Documentation For Authorization


Authentication schemes defined for the API:
<a id="HTTPBearer"></a>
### HTTPBearer

- **Type**: Bearer authentication

<a id="APIKeyHeader"></a>
### APIKeyHeader

- **Type**: API key
- **API key parameter name**: Origin
- **Location**: HTTP header


## Author




