# coding: utf-8

"""
    Mentortools Public API

    Mentortools public API service

    The version of the OpenAPI document: 0.1.0
    Generated by OpenAPI Generator (https://openapi-generator.tech)

    Do not edit the class manually.
"""  # noqa: E501


from __future__ import annotations
import pprint
import re  # noqa: F401
import json


from typing import Optional
from pydantic import BaseModel, Field, StrictInt, StrictStr

class CourseToVideo(BaseModel):
    """
    CourseToVideo
    """
    id: StrictInt = Field(...)
    course_id: StrictInt = Field(default=..., description="ID of the course associated with the video module")
    file_id: Optional[StrictStr] = Field(default=None, description="ID of the video file on file service associated with the course module")
    title: Optional[StrictStr] = Field(default='', description="Title of the video")
    link: Optional[StrictStr] = Field(default='', description="Link to the video file if it is hosted externally")
    __properties = ["id", "course_id", "file_id", "title", "link"]

    class Config:
        """Pydantic configuration"""
        allow_population_by_field_name = True
        validate_assignment = True

    def to_str(self) -> str:
        """Returns the string representation of the model using alias"""
        return pprint.pformat(self.dict(by_alias=True))

    def to_json(self) -> str:
        """Returns the JSON representation of the model using alias"""
        return json.dumps(self.to_dict())

    @classmethod
    def from_json(cls, json_str: str) -> CourseToVideo:
        """Create an instance of CourseToVideo from a JSON string"""
        return cls.from_dict(json.loads(json_str))

    def to_dict(self):
        """Returns the dictionary representation of the model using alias"""
        _dict = self.dict(by_alias=True,
                          exclude={
                          },
                          exclude_none=True)
        return _dict

    @classmethod
    def from_dict(cls, obj: dict) -> CourseToVideo:
        """Create an instance of CourseToVideo from a dict"""
        if obj is None:
            return None

        if not isinstance(obj, dict):
            return CourseToVideo.parse_obj(obj)

        _obj = CourseToVideo.parse_obj({
            "id": obj.get("id"),
            "course_id": obj.get("course_id"),
            "file_id": obj.get("file_id"),
            "title": obj.get("title") if obj.get("title") is not None else '',
            "link": obj.get("link") if obj.get("link") is not None else ''
        })
        return _obj


