# coding: utf-8

"""
    Mentortools Public API

    Mentortools public API service

    The version of the OpenAPI document: 0.1.0
    Generated by OpenAPI Generator (https://openapi-generator.tech)

    Do not edit the class manually.
"""  # noqa: E501


from __future__ import annotations
import pprint
import re  # noqa: F401
import json


from typing import List, Optional
from pydantic import BaseModel, Field, StrictBool, StrictInt, StrictStr, conlist
from landing_page_server_connector.models.course_access_type_str_enum import CourseAccessTypeStrEnum
from landing_page_server_connector.models.course_content_block import CourseContentBlock
from landing_page_server_connector.models.course_module import CourseModule
from landing_page_server_connector.models.course_module_view_type_str_enum import CourseModuleViewTypeStrEnum
from landing_page_server_connector.models.course_payment_type_str_enum import CoursePaymentTypeStrEnum
from landing_page_server_connector.models.course_to_video import CourseToVideo

class Course(BaseModel):
    """
    Course
    """
    title: StrictStr = Field(default=..., description="Title of the course")
    image_id: Optional[StrictStr] = Field(default=None, description="ID of the course image on file service")
    description: Optional[StrictStr] = Field(default='', description="Description of the course")
    url: Optional[StrictStr] = Field(default='', description="URL of the sales page, if landing page is not used")
    payload: Optional[StrictStr] = Field(default='', description="Additional payload for the course, text or HTML content")
    module_view_type: Optional[CourseModuleViewTypeStrEnum] = None
    payment_type: Optional[CoursePaymentTypeStrEnum] = None
    course_access_type: Optional[CourseAccessTypeStrEnum] = None
    number_days_access: Optional[StrictInt] = 0
    is_active: StrictBool = Field(default=..., description="Whether the course is active and available for users")
    is_secret: StrictBool = Field(default=..., description="Whether the course is secret and not listed publicly on dashboard, does not affect visibility in the mobile app")
    is_archived: StrictBool = Field(default=..., description="Whether the course is archived (deleted and to be removed from database)")
    is_displayed_in_app: StrictBool = Field(default=..., description="Whether the course is displayed in mobile app, unrelated to the course visibility in the web app")
    is_offline_downloadable: StrictBool = Field(default=..., description="Whether the course can be downloaded for offline access in the mobile app")
    available_at: Optional[StrictInt] = None
    launch_date_enabled: Optional[StrictBool] = False
    launch_date: Optional[StrictInt] = 0
    id: StrictInt = Field(...)
    portal_id: StrictInt = Field(...)
    order: StrictInt = Field(...)
    category: Optional[StrictStr] = ''
    category_id: Optional[StrictInt] = None
    sales_page_landing_id: Optional[StrictInt] = None
    permalink: Optional[StrictStr] = None
    enable_double_optin: Optional[StrictBool] = False
    one_more_landing_id: Optional[StrictInt] = None
    one_more_step_link: Optional[StrictStr] = None
    one_more_step_landing_id: Optional[StrictInt] = None
    created_at_epoch: StrictInt = Field(...)
    modules: conlist(CourseModule) = Field(...)
    content_blocks: conlist(CourseContentBlock) = Field(...)
    video_files: conlist(CourseToVideo) = Field(...)
    __properties = ["title", "image_id", "description", "url", "payload", "module_view_type", "payment_type", "course_access_type", "number_days_access", "is_active", "is_secret", "is_archived", "is_displayed_in_app", "is_offline_downloadable", "available_at", "launch_date_enabled", "launch_date", "id", "portal_id", "order", "category", "category_id", "sales_page_landing_id", "permalink", "enable_double_optin", "one_more_landing_id", "one_more_step_link", "one_more_step_landing_id", "created_at_epoch", "modules", "content_blocks", "video_files"]

    class Config:
        """Pydantic configuration"""
        allow_population_by_field_name = True
        validate_assignment = True

    def to_str(self) -> str:
        """Returns the string representation of the model using alias"""
        return pprint.pformat(self.dict(by_alias=True))

    def to_json(self) -> str:
        """Returns the JSON representation of the model using alias"""
        return json.dumps(self.to_dict())

    @classmethod
    def from_json(cls, json_str: str) -> Course:
        """Create an instance of Course from a JSON string"""
        return cls.from_dict(json.loads(json_str))

    def to_dict(self):
        """Returns the dictionary representation of the model using alias"""
        _dict = self.dict(by_alias=True,
                          exclude={
                          },
                          exclude_none=True)
        # override the default output from pydantic by calling `to_dict()` of each item in modules (list)
        _items = []
        if self.modules:
            for _item in self.modules:
                if _item:
                    _items.append(_item.to_dict())
            _dict['modules'] = _items
        # override the default output from pydantic by calling `to_dict()` of each item in content_blocks (list)
        _items = []
        if self.content_blocks:
            for _item in self.content_blocks:
                if _item:
                    _items.append(_item.to_dict())
            _dict['content_blocks'] = _items
        # override the default output from pydantic by calling `to_dict()` of each item in video_files (list)
        _items = []
        if self.video_files:
            for _item in self.video_files:
                if _item:
                    _items.append(_item.to_dict())
            _dict['video_files'] = _items
        return _dict

    @classmethod
    def from_dict(cls, obj: dict) -> Course:
        """Create an instance of Course from a dict"""
        if obj is None:
            return None

        if not isinstance(obj, dict):
            return Course.parse_obj(obj)

        _obj = Course.parse_obj({
            "title": obj.get("title"),
            "image_id": obj.get("image_id"),
            "description": obj.get("description") if obj.get("description") is not None else '',
            "url": obj.get("url") if obj.get("url") is not None else '',
            "payload": obj.get("payload") if obj.get("payload") is not None else '',
            "module_view_type": obj.get("module_view_type"),
            "payment_type": obj.get("payment_type"),
            "course_access_type": obj.get("course_access_type"),
            "number_days_access": obj.get("number_days_access") if obj.get("number_days_access") is not None else 0,
            "is_active": obj.get("is_active"),
            "is_secret": obj.get("is_secret"),
            "is_archived": obj.get("is_archived"),
            "is_displayed_in_app": obj.get("is_displayed_in_app"),
            "is_offline_downloadable": obj.get("is_offline_downloadable"),
            "available_at": obj.get("available_at"),
            "launch_date_enabled": obj.get("launch_date_enabled") if obj.get("launch_date_enabled") is not None else False,
            "launch_date": obj.get("launch_date") if obj.get("launch_date") is not None else 0,
            "id": obj.get("id"),
            "portal_id": obj.get("portal_id"),
            "order": obj.get("order"),
            "category": obj.get("category") if obj.get("category") is not None else '',
            "category_id": obj.get("category_id"),
            "sales_page_landing_id": obj.get("sales_page_landing_id"),
            "permalink": obj.get("permalink"),
            "enable_double_optin": obj.get("enable_double_optin") if obj.get("enable_double_optin") is not None else False,
            "one_more_landing_id": obj.get("one_more_landing_id"),
            "one_more_step_link": obj.get("one_more_step_link"),
            "one_more_step_landing_id": obj.get("one_more_step_landing_id"),
            "created_at_epoch": obj.get("created_at_epoch"),
            "modules": [CourseModule.from_dict(_item) for _item in obj.get("modules")] if obj.get("modules") is not None else None,
            "content_blocks": [CourseContentBlock.from_dict(_item) for _item in obj.get("content_blocks")] if obj.get("content_blocks") is not None else None,
            "video_files": [CourseToVideo.from_dict(_item) for _item in obj.get("video_files")] if obj.get("video_files") is not None else None
        })
        return _obj


