#  Copyright (C) 2024
#  ABM, Moscow
#
#  UNPUBLISHED PROPRIETARY MATERIAL.
#  ALL RIGHTS RESERVED.
#
#  Authors: Vasya Svintsov <v.svintsov@techokert.ru>

from dataclasses import dataclass

from http_tools import AbmServiceConnector
from init_helpers.dict_to_dataclass import get_converter


class NetrisProviderConnector:
    @dataclass(kw_only=True)
    class Config(AbmServiceConnector.Config):
        server_name: str

    Context = AbmServiceConnector.Context

    def __init__(self, config: Config, context: Context) -> None:
        self._config = config
        self._context = context
        self._connector = AbmServiceConnector(config, context)

    async def get_camera_outer_id_to_inner_id(self, outer_ids: list[str]) -> dict[str, int]:
        camera_outer_id_to_inner_id = await self._connector.post(
            '/camera_matching/outer_id_to_inner_id/get', {'ids': outer_ids}, headers=self._prepare_headers(),
        )
        return get_converter(dict[str, int])(camera_outer_id_to_inner_id)

    async def get_camera_inner_id_to_outer_id(self, inner_ids: list[int]) -> dict[int, str]:
        camera_inner_id_to_outer_id = await self._connector.post(
            '/camera_matching/inner_id_to_outer_id/get', {'ids': inner_ids}, headers=self._prepare_headers(),
        )
        return get_converter(dict[int, str])(camera_inner_id_to_outer_id)

    def _prepare_headers(self) -> dict[str, str]:
        return {"server_name": self._config.server_name}
