import json
from typing import Any

from utils.abstract_encoder import AbstractEncoder


class JsonEncoder(AbstractEncoder):
    def encode(self, data: dict[str, Any]) -> bytes:
        return json.dumps(data).encode('utf8')

    def decode(self, payload: bytes) -> dict[str, Any]:
        return json.loads(payload.decode('utf8'))
