# coding: utf-8

"""
    OpenAI Connector server

    No description provided (generated by Openapi Generator https://github.com/openapitools/openapi-generator)

    The version of the OpenAPI document: 0.1.0
    Generated by OpenAPI Generator (https://openapi-generator.tech)

    Do not edit the class manually.
"""  # noqa: E501


from __future__ import annotations
import pprint
import re  # noqa: F401
import json



from pydantic import BaseModel, Field, StrictInt, StrictStr, validator

class ImageSettings(BaseModel):
    """
    ImageSettings
    """
    model: StrictStr = Field(...)
    count: StrictInt = Field(...)
    size: StrictStr = Field(...)
    quality: StrictStr = Field(...)
    output_format: StrictStr = Field(...)
    __properties = ["model", "count", "size", "quality", "output_format"]

    @validator('model')
    def model_validate_enum(cls, value):
        """Validates the enum"""
        if value not in ('dall-e-2', 'dall-e-3', 'gpt-image-1',):
            raise ValueError("must be one of enum values ('dall-e-2', 'dall-e-3', 'gpt-image-1')")
        return value

    @validator('size')
    def size_validate_enum(cls, value):
        """Validates the enum"""
        if value not in ('auto', '1024x1024', '1536x1024', '1024x1536', '1792x1024',):
            raise ValueError("must be one of enum values ('auto', '1024x1024', '1536x1024', '1024x1536', '1792x1024')")
        return value

    @validator('quality')
    def quality_validate_enum(cls, value):
        """Validates the enum"""
        if value not in ('low', 'medium', 'high', 'auto', 'standard',):
            raise ValueError("must be one of enum values ('low', 'medium', 'high', 'auto', 'standard')")
        return value

    @validator('output_format')
    def output_format_validate_enum(cls, value):
        """Validates the enum"""
        if value not in ('png', 'jpeg', 'webp',):
            raise ValueError("must be one of enum values ('png', 'jpeg', 'webp')")
        return value

    class Config:
        """Pydantic configuration"""
        allow_population_by_field_name = True
        validate_assignment = True

    def to_str(self) -> str:
        """Returns the string representation of the model using alias"""
        return pprint.pformat(self.dict(by_alias=True))

    def to_json(self) -> str:
        """Returns the JSON representation of the model using alias"""
        return json.dumps(self.to_dict())

    @classmethod
    def from_json(cls, json_str: str) -> ImageSettings:
        """Create an instance of ImageSettings from a JSON string"""
        return cls.from_dict(json.loads(json_str))

    def to_dict(self):
        """Returns the dictionary representation of the model using alias"""
        _dict = self.dict(by_alias=True,
                          exclude={
                          },
                          exclude_none=True)
        return _dict

    @classmethod
    def from_dict(cls, obj: dict) -> ImageSettings:
        """Create an instance of ImageSettings from a dict"""
        if obj is None:
            return None

        if not isinstance(obj, dict):
            return ImageSettings.parse_obj(obj)

        _obj = ImageSettings.parse_obj({
            "model": obj.get("model"),
            "count": obj.get("count"),
            "size": obj.get("size"),
            "quality": obj.get("quality"),
            "output_format": obj.get("output_format")
        })
        return _obj


