#  Copyright (C) 2025
#  ABM, Moscow
#
#  UNPUBLISHED PROPRIETARY MATERIAL.
#  ALL RIGHTS RESERVED.
#
#  Authors: Mike Orlov <m.orlov@abm-jsc.ru>
from dataclasses import dataclass
from typing import ClassVar, Any

from http_tools import ContentType, IncomingRequest
from init_helpers import raise_if

from .body_parameter import BodyParameter


@dataclass(frozen=True, kw_only=True)
class JsonBodyParameter(BodyParameter):
    body_mime_type: ClassVar[ContentType] = ContentType.Json

    def _get(self, incoming_request: IncomingRequest) -> Any:
        raise_if(incoming_request.parsed_body is None, KeyError(self.name))
        return incoming_request.parsed_body[self.name]
