#  Copyright (C) 2025
#  ABM, Moscow
#
#  UNPUBLISHED PROPRIETARY MATERIAL.
#  ALL RIGHTS RESERVED.
#
#  Authors: Mike Orlov <m.orlov@abm-jsc.ru>
import abc
# import functools
from dataclasses import dataclass

from .maybe_referencable_resource import MaybeReferencableResource
# from .spec_ref import SpecRef
from .spec_resource import SpecResource


@dataclass(frozen=True, slots=True)
class ReferencableResource(MaybeReferencableResource):
    @abc.abstractmethod
    def get_key(self) -> str:
        raise NotImplementedError

    # def get_spec_ref(self) -> SpecRef | str:
    #     return SpecRef(f'{"/".join(self.spec_path + [self.get_key()])}')

    # @functools.cache
    # def get_spec_referencable_dependencies(self) -> frozenset['ReferencableResource']:
    #     return frozenset(filter(lambda x: isinstance(x, ReferencableResource), self.get_spec_dependencies()))
