#  Copyright (C) 2025
#  ABM, Moscow
#
#  UNPUBLISHED PROPRIETARY MATERIAL.
#  ALL RIGHTS RESERVED.
#
#  Authors: Mike Orlov <m.orlov@abm-jsc.ru>
import abc

from frozendict import frozendict

from ..call_parameter import CallParameter
from ..spec_parameter import SpecParameter


class ParameterAggregation(CallParameter, abc.ABC):
    @abc.abstractmethod
    def get_spec_parameters(self) -> frozendict['SpecParameter', None]:
        pass
