#  Copyright (C) 2025
#  ABM, Moscow
#
#  UNPUBLISHED PROPRIETARY MATERIAL.
#  ALL RIGHTS RESERVED.
#
#  Authors: Mike Orlov <m.orlov@abm-jsc.ru>
import json
from typing import Any

from frozendict import deepfreeze
from init_helpers import custom_dumps, try_extract_type_notes, AnyType


def freeze(val: Any):
    # Spike, TODO: think over it
    return deepfreeze(json.loads(custom_dumps(val)))


def repr_type(schema: AnyType) -> str:
    schema, notes = try_extract_type_notes(schema)
    if notes:
        return f'Annotated[{schema.__name__}, {", ".join(map(repr, notes))}]'
    return schema.__name__ if isinstance(schema, type) else str(schema)