#  Copyright (C) 2025
#  ABM, Moscow
#
#  UNPUBLISHED PROPRIETARY MATERIAL.
#  ALL RIGHTS RESERVED.
#
#  Authors: Mike Orlov <m.orlov@abm-jsc.ru>
from dataclasses import dataclass
from typing import ClassVar

from .composite_schema import CompositeSchema


@dataclass(frozen=True, slots=True)
class AnyOfSchema(CompositeSchema):
    composition_keyword: ClassVar[str] = 'anyOf'

    def __repr__(self):
        return f'{self.__class__.__name__}({", ".join(self._get_repr_parts())})'

    __str__ = __repr__
